-- Calculate the measure impacts for the measures specified in the current_msr_mat table.
--  Note: use more decimals than necessary, as they will be rounded in the final query of the process
DROP TABLE IF EXISTS meas_impacts;

CREATE TABLE meas_impacts(
  EnergyImpactID TEXT NOT NULL,
  Version TEXT,
  VersionSource TEXT,
  LastMod TEXT,
  PA TEXT NOT NULL,
  BldgType TEXT NOT NULL,
  BldgVint TEXT NOT NULL,
  BldgLoc TEXT NOT NULL,
  BldgHVAC TEXT NOT NULL,
  NormUnit TEXT,
  NumUnit REAL,
  MeasArea REAL,
  ScaleBasis TEXT,
  PreWBkWh REAL,
  PreWBkW25 REAL,
  PreWBkW49 REAL,
  PreWBthm REAL,
  StdWBkWh REAL,
  StdWBkW25 REAL,
  StdWBkW49 REAL,
  StdWBthm REAL,
  MsrWBkWh REAL,
  MsrWBkW25 REAL,
  MsrWBkW49 REAL,
  MsrWBthm REAL,
  APreWBkWh REAL,
  APreWBkW25 REAL,
  APreWBkW49 REAL,
  APreWBtherm REAL,
  AStdWBkWh REAL,
  AStdWBkW25 REAL,
  AStdWBkW49 REAL,
  AStdWBtherm REAL,
  "Note1" TEXT,
  PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC")
);


INSERT INTO meas_impacts
SELECT
current_msr_mat."MeasureID" as "EnergyImpactID",
'ExAnte2020' as "Version",
'IOU Workpaper' as "VersionSource",
datetime('now') as "LastMod",
'Any' as "PA",
current_msr_mat."BldgType",
current_msr_mat."BldgVint",
current_msr_mat."BldgLoc",
current_msr_mat."BldgHVAC",
msr.normunit as "NormUnit",
msr.numunits as "NumUnit",
msr.measarea as "MeasArea",
'None' as "ScaleBasis",
-- Pre-Existing case Values:
CAST(pre.kwh_tot as REAL) as "PreWBkWh", 
CAST(ppk.bldg_kw25 as REAL) as "PreWBkW25", 
CAST(ppk.bldg_kw49 as REAL) as "PreWBkW49", 
CAST(pre.thm_tot AS REAL) as "PreWBthm",
-- Standard practice baseline case
CAST(std.kwh_tot as REAL) as "StdWBkWh", 
CAST(spk.bldg_kw25 as REAL) as "StdWBkW25", 
CAST(spk.bldg_kw49 as REAL) as "StdWBkW49", 
CAST(std.thm_tot AS REAL) as "StdWBthm",
-- Measure case
CAST(msr.kwh_tot as REAL) as "MsrWBkWh", 
CAST(mpk.bldg_kw25 as REAL) as "MsrWBkW25", 
CAST(mpk.bldg_kw49 as REAL) as "MsrWBkW49", 
CAST(msr.thm_tot AS REAL) as "MsrWBthm",


-- DEER whole-building, above pre-exising impacts
case (pre.kwh_tot - msr.kwh_tot) when 0 then 0 
  else cast((pre.kwh_tot - msr.kwh_tot)/msr.numunits as REAL) end as "APreWBkWh", 
case (ppk.bldg_kw25 - mpk.bldg_kw25) when 0 then 0 
  else cast((ppk.bldg_kw25 - mpk.bldg_kw25)/msr.numunits as real) end as "APreWBkW25", 
case (ppk.bldg_kw49 - mpk.bldg_kw49) when 0 then 0 
  else cast((ppk.bldg_kw49 - mpk.bldg_kw49)/msr.numunits as real) end as "APreWBkW49", 
case (pre.thm_tot - msr.thm_tot) when 0 then 0 
  else cast((pre.thm_tot - msr.thm_tot)/msr.numunits as real) end as "APreWBtherm", 
-- DEER whole-building, above code/standard impacts
case (std.kwh_tot - msr.kwh_tot) when 0 then 0 
  else cast((std.kwh_tot - msr.kwh_tot)/msr.numunits as real) end as "AStdWBkWh", 
case (spk.bldg_kw25 - mpk.bldg_kw25) when 0 then 0 
  else cast((spk.bldg_kw25 - mpk.bldg_kw25)/msr.numunits as real) end as "AStdWBkW25", 
case (spk.bldg_kw49 - mpk.bldg_kw49) when 0 then 0 
  else cast((spk.bldg_kw49 - mpk.bldg_kw49)/msr.numunits as real) end as "AStdWBkW49", 
case (std.thm_tot - msr.thm_tot) when 0 then 0 
  else cast((std.thm_tot - msr.thm_tot)/msr.numunits as real) end as "AStdWBtherm",
'Created by Solaris Technical using DEER2020 methodology' as "Note1"

FROM current_msr_mat
LEFT JOIN sim_annual_wtd msr on 
  msr."TechID"   = current_msr_mat."MsrTechID" AND  
  msr."SizingID" = current_msr_mat."MsrSizingID" AND  
  msr."BldgType" = current_msr_mat."BldgType" AND
  msr."BldgVint" = current_msr_mat."BldgVint" AND  
  msr."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  msr."BldgHVAC" = current_msr_mat."BldgHVAC"
LEFT JOIN sim_annual_wtd pre on 
  pre."TechID"   = current_msr_mat."PreTechID" AND  
  pre."SizingID" = current_msr_mat."PreSizingID" AND  
  pre."BldgType" = current_msr_mat."BldgType" AND
  pre."BldgVint" = current_msr_mat."BldgVint" AND  
  pre."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  pre."BldgHVAC" = current_msr_mat."BldgHVAC"
LEFT JOIN sim_annual_wtd std on 
  std."TechID"   = current_msr_mat."StdTechID" AND  
  std."SizingID" = current_msr_mat."StdSizingID" AND  
  std."BldgType" = current_msr_mat."BldgType" AND
  std."BldgVint" = current_msr_mat."BldgVint" AND  
  std."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  std."BldgHVAC" = current_msr_mat."BldgHVAC"
LEFT JOIN sim_peakper mpk ON
  mpk."TechID"   = current_msr_mat."MsrTechID" AND  
  mpk."SizingID" = current_msr_mat."MsrSizingID" AND  
  mpk."BldgType" = current_msr_mat."BldgType" AND
  mpk."BldgVint" = current_msr_mat."BldgVint" AND  
  mpk."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  mpk."BldgHVAC" = current_msr_mat."BldgHVAC"
LEFT JOIN sim_peakper ppk ON
  ppk."TechID"   = current_msr_mat."PreTechID" AND  
  ppk."SizingID" = current_msr_mat."PreSizingID" AND  
  ppk."BldgType" = current_msr_mat."BldgType" AND
  ppk."BldgVint" = current_msr_mat."BldgVint" AND  
  ppk."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  ppk."BldgHVAC" = current_msr_mat."BldgHVAC"
LEFT JOIN sim_peakper spk ON
  spk."TechID"   = current_msr_mat."StdTechID" AND  
  spk."SizingID" = current_msr_mat."StdSizingID" AND  
  spk."BldgType" = current_msr_mat."BldgType" AND
  spk."BldgVint" = current_msr_mat."BldgVint" AND  
  spk."BldgLoc"  = current_msr_mat."BldgLoc" AND  
  spk."BldgHVAC" = current_msr_mat."BldgHVAC"
WHERE current_msr_mat.tstat = '1'
ORDER BY 
 current_msr_mat."MeasureID",current_msr_mat."BldgType",current_msr_mat."BldgHVAC",current_msr_mat."BldgVint",current_msr_mat."BldgLoc";
 